'VK3DIP July/August/September 2021

'Read electronic compass with I2C then RS232 result at vatious BPS
'for HMC5883/HMC5983 I2C Base = 0x1E ie. read = 0x3D, write 0x3C
'for QMC5883 I2C Base = 0x0D ie. read = 0x1B, write 0x1A
'And different registers so will require changes.
'in oshonsoft basic use write address
'V0.8 change to have hex chars use upper case A-F
'V1.0 change to simple numbers
'V1.1 Lower to 300 Baud
'V1.2 Variable Baud depending on Jumpers
'V1.3 Fixed pull ups and moved into loop
'V1.3Q QMC5883 version
'V2.0 use jumpers to select QMC or HMC 5883

Define CONFIG = 0x31e4  'Uses 12f629  and internal clock at 4MHz
Define CLOCK_FREQUENCY = 4
Define SEROUT_DELAYUS = 1000

'Using Soft Serial at 300->3300 and internal osc it is important that
'the clock is As accurate As possible, so we must
'set OSCCAL to individual factory etc. predetermined
'value normally factory (or pickit2) saved in location 3FF

ASM:        BSF STATUS,RP0
ASM:        CALL 0x3ff
ASM:        MOVWF OSCCAL
ASM:        BCF STATUS,RP0

'Symbols
Symbol scl = GP0
Symbol sda = GP1
Symbol TXout = GP2
Symbol SW1 = GP4
Symbol SW2 = GP5
'SW1 short (low/0) = HMC5883L, SW1 open (Hi/1) = QMC5883
'SW2 short (low/0) = 2400, SW1 open (Hi/1) = 1200
Const I2CaddH = 0x3c  'HMC5883l
Const I2CaddQ = 0x1a  'QMC5883

All_Digital
TRISIO = %00111000  'GP0 , GP1, GP2 2 out, rest set to input.
WPU = %00111000  'weak pull ups off for outputs, on for inputs
OPTION.7 = 0  'Enable pull ups

'Variables

Dim Xval As Word
Dim Yval As Word
Dim Zval As Word
'Main

'make SW1 short (low/0/false) = HMC5883L, SW1 open (Hi/1/true) = QMC5883
'make SW2 short (low/0/false) = 2400, SW1 open (Hi/1/true) = 1200

	WaitMs 6  'just for things to stabilize

	If SW1 Then
		'configure the QMC5883
		I2CWrite sda, scl, I2CaddQ, 0x0b, %00000001  'QMC5883 define set reset period
		I2CWrite sda, scl, I2CaddQ, 0x09, %01000001  'Set Gain 2 , 256 average(OSR), 10 Hz(ODR), continuous measurement
	Else
		'configure the HMC5883
		I2CWrite sda, scl, I2CaddH, 0x00, %01110000  'HMC5883 8-average, 15 Hz default, normal measurement
		I2CWrite sda, scl, I2CaddH, 0x01, %01100000  'Set Gain 2.5 , Set higher or lower if needed
		I2CWrite sda, scl, I2CaddH, 0x02, %00000000  'low speed i2c, Continuous-measurement mode)
	Endif

	'Dont do/send anything for a while (500mS)
	'this helps with debugging if directly connected to windows
	'imeadiate serial data on a port on power on can be interpreted as a serial mouse
	'with unexpected consequences.
	WaitMs 500

loop:
	If SW1 Then
			'read the QMC5883 field values
		I2CRead sda, scl, I2CaddQ, 0x00, Xval.LB  'X LSB
		I2CRead sda, scl, I2CaddQ, 0x01, Xval.HB  'X MSB
		I2CRead sda, scl, I2CaddQ, 0x02, Yval.LB  'Y LSB
		I2CRead sda, scl, I2CaddQ, 0x03, Yval.HB  'Y MSB
		I2CRead sda, scl, I2CaddQ, 0x04, Zval.LB  'Z LSB
		I2CRead sda, scl, I2CaddQ, 0x05, Zval.HB  'Z MSB
	Else
			'read the HMC5883Lfield values
		I2CRead sda, scl, I2CaddH, 0x03, Xval.HB  'X MSB
		I2CRead sda, scl, I2CaddH, 0x04, Xval.LB  'X MSB
		I2CRead sda, scl, I2CaddH, 0x05, Zval.HB  'Z MSB
		I2CRead sda, scl, I2CaddH, 0x06, Zval.LB  'Z LSB
		I2CRead sda, scl, I2CaddH, 0x07, Yval.HB  'Y MSB
		I2CRead sda, scl, I2CaddH, 0x08, Yval.LB  'Y LSB
	Endif

	'Send results via serial in form "<XXXX,YYYY,ZZZZ><CR><LF>" where X's Y's and Z's are ascii number of the field values
	'Note negatives in 2s complement eg 65534 = -1
	If SW2 Then
		Serout TXout, 1200, "<", "X:", #Xval, ",", "Y:", #Yval, ",", "Z:", #Zval, ",", ">", CrLf
	Else
		Serout TXout, 2400, "<", "X:", #Xval, ",", "Y:", #Yval, ",", "Z:", #Zval, ",", ">", CrLf
	Endif
	
	'we should wait > 67ms ( 1/15) for HMC at15 Hz resampling for new XYZ values, but don't need to because of serial send.
	'for the QMC5883 at 10Hz ie. >100mS so 1200 is fine, 2400 is marginal.
	'for average 22 chars equive delay is:
	'1200 = 185mS
	'2400 = 92mS
	
Goto loop

End                                               



