; Compiled with: OshonSoft PIC Basic Compiler v7.971
; Microcontroller model: PIC12F629
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R3H EQU 0x027
	R4L EQU 0x028
	R4H EQU 0x029
	R5L EQU 0x02A
	R5H EQU 0x02B
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R3HL EQU 0x026
	R4HL EQU 0x028
	R5HL EQU 0x02A
	R1HL0HL EQU 0x020
	R3HL2HL EQU 0x024
	R5HL4HL EQU 0x028
	SO_PORT EQU 0x035
	SO_BIT EQU 0x036
	SO_INTL EQU 0x037
	SO_INTH EQU 0x038
	SCL_PORT EQU 0x039
	SCL_BIT EQU 0x03A
	SDA_PORT EQU 0x03B
	SDA_BIT EQU 0x03C
;       The value of 'I2CaddH' (global) is 60
;       The value of 'I2CaddQ' (global) is 26
;       The address of 'Xval' (word) (global) is 0x03D
;       The address of 'Yval' (word) (global) is 0x03F
;       The address of 'Zval' (word) (global) is 0x041
;       The address of 'scl' (bit) (global) is 0x005,0
;       The address of 'sda' (bit) (global) is 0x005,1
;       The address of 'TXout' (bit) (global) is 0x005,2
;       The address of 'SW1' (bit) (global) is 0x005,4
;       The address of 'SW2' (bit) (global) is 0x005,5
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0003
	ORG 0x0004
	RETFIE
; User code start
L0003:
; 1: 'VK3DIP July/August/September 2021
; 2: 
; 3: 'Read electronic compass with I2C then RS232 result at vatious BPS
; 4: 'for HMC5883/HMC5983 I2C Base = 0x1E ie. read = 0x3D, write 0x3C
; 5: 'for QMC5883 I2C Base = 0x0D ie. read = 0x1B, write 0x1A
; 6: 'And different registers so will require changes.
; 7: 'in oshonsoft basic use write address
; 8: 'V0.8 change to have hex chars use upper case A-F
; 9: 'V1.0 change to simple numbers
; 10: 'V1.1 Lower to 300 Baud
; 11: 'V1.2 Variable Baud depending on Jumpers
; 12: 'V1.3 Fixed pull ups and moved into loop
; 13: 'V1.3Q QMC5883 version
; 14: 'V2.0 use jumpers to select QMC or HMC 5883
; 15: 
; 16: Define CONFIG = 0x31e4  'Uses 12f629  and internal clock at 4MHz
;       The value of 'CONFIG' is 12772
; 17: Define CLOCK_FREQUENCY = 4
;       The value of 'CLOCK_FREQUENCY' is 4
; 18: Define SEROUT_DELAYUS = 1000
;       The value of 'SEROUT_DELAYUS' is 1000
; 19: 
; 20: 'Using Soft Serial at 300->3300 and internal osc it is important that
; 21: 'the clock is As accurate As possible, so we must
; 22: 'set OSCCAL to individual factory etc. predetermined
; 23: 'value normally factory (or pickit2) saved in location 3FF
; 24: 
; 25: ASM:        BSF STATUS,RP0
	BSF STATUS,RP0
; 26: ASM:        CALL 0x3ff
	CALL 0x3ff
; 27: ASM:        MOVWF OSCCAL
	MOVWF OSCCAL
; 28: ASM:        BCF STATUS,RP0
	BCF STATUS,RP0
; 29: 
; 30: 'Symbols
; 31: Symbol scl = GP0
; 32: Symbol sda = GP1
; 33: Symbol TXout = GP2
; 34: Symbol SW1 = GP4
; 35: Symbol SW2 = GP5
; 36: 'SW1 short (low/0) = HMC5883L, SW1 open (Hi/1) = QMC5883
; 37: 'SW2 short (low/0) = 2400, SW1 open (Hi/1) = 1200
; 38: Const I2CaddH = 0x3c  'HMC5883l
; 39: Const I2CaddQ = 0x1a  'QMC5883
; 40: 
; 41: All_Digital
	MOVLW 0x07
	MOVWF CMCON
; 42: TRISIO = %00111000  'GP0 , GP1, GP2 2 out, rest set to input.
	MOVLW 0x38
	BSF STATUS,RP0
	MOVWF TRISIO
	BCF STATUS,RP0
; 43: WPU = %00111000  'weak pull ups off for outputs, on for inputs
	MOVLW 0x38
	BSF STATUS,RP0
	MOVWF WPU
; 44: OPTION.7 = 0  'Enable pull ups
	BCF OPTION_REG,7
	BCF STATUS,RP0
; 45: 
; 46: 'Variables
; 47: 
; 48: Dim Xval As Word
; 49: Dim Yval As Word
; 50: Dim Zval As Word
; 51: 'Main
; 52: 
; 53: 'make SW1 short (low/0/false) = HMC5883L, SW1 open (Hi/1/true) = QMC5883
; 54: 'make SW2 short (low/0/false) = 2400, SW1 open (Hi/1/true) = 1200
; 55: 
; 56: WaitMs 6  'just for things to stabilize
	MOVLW 0x56
	MOVWF R4L
	MOVLW 0x02
	MOVWF R4H
	CALL DL02
; 57: 
; 58: If SW1 Then
	BTFSS 0x005,4
	GOTO L0004
; 59: 'configure the QMC5883
; 60: I2CWrite sda, scl, I2CaddQ, 0x0b, %00000001  'QMC5883 define set reset period
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x1A
	CALL IC01
	MOVLW 0x0B
	CALL IC01
	MOVLW 0x01
	CALL IC01
	CALL IC41
; 61: I2CWrite sda, scl, I2CaddQ, 0x09, %01000001  'Set Gain 2 , 256 average(OSR), 10 Hz(ODR), continuous measurement
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x1A
	CALL IC01
	MOVLW 0x09
	CALL IC01
	MOVLW 0x41
	CALL IC01
	CALL IC41
; 62: Else
	GOTO L0005
L0004:
; 63: 'configure the HMC5883
; 64: I2CWrite sda, scl, I2CaddH, 0x00, %01110000  'HMC5883 8-average, 15 Hz default, normal measurement
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x3C
	CALL IC01
	MOVLW 0x00
	CALL IC01
	MOVLW 0x70
	CALL IC01
	CALL IC41
; 65: I2CWrite sda, scl, I2CaddH, 0x01, %01100000  'Set Gain 2.5 , Set higher or lower if needed
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x3C
	CALL IC01
	MOVLW 0x01
	CALL IC01
	MOVLW 0x60
	CALL IC01
	CALL IC41
; 66: I2CWrite sda, scl, I2CaddH, 0x02, %00000000  'low speed i2c, Continuous-measurement mode)
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x3C
	CALL IC01
	MOVLW 0x02
	CALL IC01
	MOVLW 0x00
	CALL IC01
	CALL IC41
; 67: Endif
L0005:
; 68: 
; 69: 'Dont do/send anything for a while (500mS)
; 70: 'this helps with debugging if directly connected to windows
; 71: 'imeadiate serial data on a port on power on can be interpreted as a serial mouse
; 72: 'with unexpected consequences.
; 73: WaitMs 500
	MOVLW 0x4E
	MOVWF R4L
	MOVLW 0xC3
	MOVWF R4H
	CALL DL02
; 74: 
; 75: loop:
L0001:
; 76: If SW1 Then
	BTFSS 0x005,4
	GOTO L0006
; 77: 'read the QMC5883 field values
; 78: I2CRead sda, scl, I2CaddQ, 0x00, Xval.LB  'X LSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x1A
	CALL IC01
	MOVLW 0x00
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x1B
	CALL IC01
	CALL IC11
	MOVWF 0x03D
	CALL IC41
; 79: I2CRead sda, scl, I2CaddQ, 0x01, Xval.HB  'X MSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x1A
	CALL IC01
	MOVLW 0x01
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x1B
	CALL IC01
	CALL IC11
	MOVWF 0x03E
	CALL IC41
; 80: I2CRead sda, scl, I2CaddQ, 0x02, Yval.LB  'Y LSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x1A
	CALL IC01
	MOVLW 0x02
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x1B
	CALL IC01
	CALL IC11
	MOVWF 0x03F
	CALL IC41
; 81: I2CRead sda, scl, I2CaddQ, 0x03, Yval.HB  'Y MSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x1A
	CALL IC01
	MOVLW 0x03
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x1B
	CALL IC01
	CALL IC11
	MOVWF 0x040
	CALL IC41
; 82: I2CRead sda, scl, I2CaddQ, 0x04, Zval.LB  'Z LSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x1A
	CALL IC01
	MOVLW 0x04
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x1B
	CALL IC01
	CALL IC11
	MOVWF 0x041
	CALL IC41
; 83: I2CRead sda, scl, I2CaddQ, 0x05, Zval.HB  'Z MSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x1A
	CALL IC01
	MOVLW 0x05
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x1B
	CALL IC01
	CALL IC11
	MOVWF 0x042
	CALL IC41
; 84: Else
	GOTO L0007
L0006:
; 85: 'read the HMC5883Lfield values
; 86: I2CRead sda, scl, I2CaddH, 0x03, Xval.HB  'X MSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x3C
	CALL IC01
	MOVLW 0x03
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x3D
	CALL IC01
	CALL IC11
	MOVWF 0x03E
	CALL IC41
; 87: I2CRead sda, scl, I2CaddH, 0x04, Xval.LB  'X MSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x3C
	CALL IC01
	MOVLW 0x04
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x3D
	CALL IC01
	CALL IC11
	MOVWF 0x03D
	CALL IC41
; 88: I2CRead sda, scl, I2CaddH, 0x05, Zval.HB  'Z MSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x3C
	CALL IC01
	MOVLW 0x05
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x3D
	CALL IC01
	CALL IC11
	MOVWF 0x042
	CALL IC41
; 89: I2CRead sda, scl, I2CaddH, 0x06, Zval.LB  'Z LSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x3C
	CALL IC01
	MOVLW 0x06
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x3D
	CALL IC01
	CALL IC11
	MOVWF 0x041
	CALL IC41
; 90: I2CRead sda, scl, I2CaddH, 0x07, Yval.HB  'Y MSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x3C
	CALL IC01
	MOVLW 0x07
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x3D
	CALL IC01
	CALL IC11
	MOVWF 0x040
	CALL IC41
; 91: I2CRead sda, scl, I2CaddH, 0x08, Yval.LB  'Y LSB
	BCF STATUS,IRP
	MOVLW 0x05
	MOVWF SDA_PORT
	MOVLW 0x02
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISIO,1
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SCL_PORT
	MOVLW 0x01
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISIO,0
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0x3C
	CALL IC01
	MOVLW 0x08
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0x3D
	CALL IC01
	CALL IC11
	MOVWF 0x03F
	CALL IC41
; 92: Endif
L0007:
; 93: 
; 94: 'Send results via serial in form "<XXXX,YYYY,ZZZZ><CR><LF>" where X's Y's and Z's are ascii number of the field values
; 95: 'Note negatives in 2s complement eg 65534 = -1
; 96: If SW2 Then
	BTFSS 0x005,5
	GOTO L0008
; 97: Serout TXout, 1200, "<", "X:", #Xval, ",", "Y:", #Yval, ",", "Z:", #Zval, ",", ">", CrLf
; exact baud rate achieved = 1201.923; bit period = 832s; baud rate error = .16%
	MOVLW 0x50
	MOVWF SO_INTL
	MOVLW 0x00
	MOVWF SO_INTH
	BSF GPIO,2
	BSF STATUS,RP0
	BCF TRISIO,2
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SO_PORT
	MOVLW 0x04
	MOVWF SO_BIT
	MOVLW 0x3C
	CALL SO01
	MOVLW 0x58
	CALL SO01
	MOVLW 0x3A
	CALL SO01
	MOVF 0x03D,W
	MOVWF 0x032
	MOVF 0x03E,W
	MOVWF 0x033
	CALL _append_lab_0001
	BCF STATUS,IRP
	MOVLW 0x2C
	MOVWF FSR
	CALL SO21
	MOVLW 0x2C
	CALL SO01
	MOVLW 0x59
	CALL SO01
	MOVLW 0x3A
	CALL SO01
	MOVF 0x03F,W
	MOVWF 0x032
	MOVF 0x040,W
	MOVWF 0x033
	CALL _append_lab_0001
	BCF STATUS,IRP
	MOVLW 0x2C
	MOVWF FSR
	CALL SO21
	MOVLW 0x2C
	CALL SO01
	MOVLW 0x5A
	CALL SO01
	MOVLW 0x3A
	CALL SO01
	MOVF 0x041,W
	MOVWF 0x032
	MOVF 0x042,W
	MOVWF 0x033
	CALL _append_lab_0001
	BCF STATUS,IRP
	MOVLW 0x2C
	MOVWF FSR
	CALL SO21
	MOVLW 0x2C
	CALL SO01
	MOVLW 0x3E
	CALL SO01
	MOVLW 0x0D
	CALL SO01
	MOVLW 0x0A
	CALL SO01
; 98: Else
	GOTO L0009
L0008:
; 99: Serout TXout, 2400, "<", "X:", #Xval, ",", "Y:", #Yval, ",", "Z:", #Zval, ",", ">", CrLf
; exact baud rate achieved = 2427.185; bit period = 412s; baud rate error = 1.13%
	MOVLW 0x26
	MOVWF SO_INTL
	MOVLW 0x00
	MOVWF SO_INTH
	BSF GPIO,2
	BSF STATUS,RP0
	BCF TRISIO,2
	BCF STATUS,RP0
	MOVLW 0x05
	MOVWF SO_PORT
	MOVLW 0x04
	MOVWF SO_BIT
	MOVLW 0x3C
	CALL SO01
	MOVLW 0x58
	CALL SO01
	MOVLW 0x3A
	CALL SO01
	MOVF 0x03D,W
	MOVWF 0x032
	MOVF 0x03E,W
	MOVWF 0x033
	CALL _append_lab_0001
	BCF STATUS,IRP
	MOVLW 0x2C
	MOVWF FSR
	CALL SO21
	MOVLW 0x2C
	CALL SO01
	MOVLW 0x59
	CALL SO01
	MOVLW 0x3A
	CALL SO01
	MOVF 0x03F,W
	MOVWF 0x032
	MOVF 0x040,W
	MOVWF 0x033
	CALL _append_lab_0001
	BCF STATUS,IRP
	MOVLW 0x2C
	MOVWF FSR
	CALL SO21
	MOVLW 0x2C
	CALL SO01
	MOVLW 0x5A
	CALL SO01
	MOVLW 0x3A
	CALL SO01
	MOVF 0x041,W
	MOVWF 0x032
	MOVF 0x042,W
	MOVWF 0x033
	CALL _append_lab_0001
	BCF STATUS,IRP
	MOVLW 0x2C
	MOVWF FSR
	CALL SO21
	MOVLW 0x2C
	CALL SO01
	MOVLW 0x3E
	CALL SO01
	MOVLW 0x0D
	CALL SO01
	MOVLW 0x0A
	CALL SO01
; 100: Endif
L0009:
; 101: 
; 102: 'we should wait > 67ms ( 1/15) for HMC at15 Hz resampling for new XYZ values, but don't need to because of serial send.
; 103: 'for the QMC5883 at 10Hz ie. >100mS so 1200 is fine, 2400 is marginal.
; 104: 'for average 22 chars equive delay is:
; 105: '1200 = 185mS
; 106: '2400 = 92mS
; 107: 
; 108: Goto loop
	GOTO L0001
; 109: 
; 110: End
L0010:	GOTO L0010
; 111: 
; 112: 
; 113: 
; Library code
L0002:
	RETURN
; End of user code
L0011:	GOTO L0011
; APPEND CODE BEGIN: _routine_ascii_word_
_append_lab_0001:
	BCF STATUS,IRP
	MOVLW 0x2C
	MOVWF FSR
	BCF 0x034,0
	MOVF 0x032,W
	MOVWF R2L
	MOVF 0x033,W
	MOVWF R2H
	MOVLW 0x10
	MOVWF R1L
	MOVLW 0x27
	MOVWF R1H
	CALL _append_lab_0002
	MOVLW 0xE8
	MOVWF R1L
	MOVLW 0x03
	MOVWF R1H
	CALL _append_lab_0002
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL _append_lab_0002
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL _append_lab_0002
	MOVF R2L,W
	CALL _append_lab_0003
	CLRF INDF
	RETURN
_append_lab_0002:
	MOVF R2L,W
	MOVWF R0L
	MOVF R2H,W
	MOVWF R0H
	CALL D001
	MOVF R0L,W
	BTFSC 0x003,2
	GOTO L0012
	BSF 0x034,0
L0012:
	BTFSS 0x034,0
	GOTO L0013
_append_lab_0003:
	ADDLW 0x30
	MOVWF INDF
	INCF FSR,f
L0013:
	RETURN
; APPEND CODE END.
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
; Serout Routine
SO01:	MOVWF R5L
	BCF STATUS,IRP
	MOVLW 0x62
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	MOVF SO_PORT,W
	MOVWF FSR
	MOVLW 0x09
	MOVWF R5H
	BCF STATUS,C
SO02:
	CALL SO03
	RRF R5L,F
	DECFSZ R5H,F
	GOTO SO02
	BSF STATUS,C
	CALL SO03
	RETURN
SO03:	MOVF INDF,W
	IORWF SO_BIT,W
	BTFSS STATUS,C
	XORWF SO_BIT,W
	MOVWF INDF
	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
	MOVF SO_INTL,W
	MOVWF R4L
	MOVF SO_INTH,W
	MOVWF R4H
	CALL DL02
	RETURN
;
;
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Serout Decimal Conversion Routine
SO21:
	MOVWF R3H
SO22:
	BCF STATUS,IRP
	MOVF R3H,W
	MOVWF FSR
	MOVF INDF,W
	BTFSC STATUS,Z
	RETURN
	INCF R3H,F
	CALL SO01
	GOTO SO22
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; I2CRead Routine
IC11:
	CALL IC24
	MOVLW 0x08
	MOVWF R0H
IC12:
	CALL IC03
	RLF R0L,F
	DECFSZ R0H,F
	GOTO IC12
	CALL IC25
	CALL IC20
	CALL IC22
	CALL IC23
	CALL IC21
	MOVF R0L,W
	RETURN
IC13:
	CALL IC24
	MOVLW 0x08
	MOVWF R0H
IC14:
	CALL IC03
	RLF R0L,F
	DECFSZ R0H,F
	GOTO IC14
	CALL IC25
	CALL IC21
	CALL IC22
	CALL IC23
	MOVF R0L,W
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x31E4
; End of listing
	END
