; Compiled with: OshonSoft PIC Basic Compiler v7.971
; Microcontroller model: PIC12F629
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R0HL EQU 0x020
	R1HL EQU 0x022
	R1HL0HL EQU 0x020
	LONG_0 EQU 0x024
	LONG_1 EQU 0x025
	LONG_2 EQU 0x026
	LONG_3 EQU 0x027
	LONG1 EQU 0x024
	ARRARG_0 EQU 0x028
	ARRARG_1 EQU 0x029
	ARRARG_2 EQU 0x02A
	ARRARG_3 EQU 0x02B
;       The address of 'ADFRegs' (array 6) (long) (global) is 0x030
;       The address of 'Sel' (byte) (global) is 0x02C
;       The address of 'i' (byte) (global) is 0x02E
;       The address of 'RegVal' (long) (WR32) is 0x048
;       The address of 'ByteVal' (byte) (WByte) is 0x02D
;       The address of 'j' (byte) (WByte) is 0x02F
;       The address of 'adf435x_LE' (bit) (global) is 0x005,2
;       The address of 'ADF435x_DATA' (bit) (global) is 0x005,1
;       The address of 'ADF435x_CLK' (bit) (global) is 0x005,0
;       The address of 'SW1' (bit) (global) is 0x005,4
;       The address of 'SW2' (bit) (global) is 0x005,5
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0004
	ORG 0x0004
	RETFIE
; User code start
L0004:
; 1: Define CONFIG = 0x31e4
;       The value of 'CONFIG' is 12772
; 2: 
; 3: 'Ultra Simple ADF435x programmer SigGen Mix Version
; 4: 'VK3DIP February 2021 V1.0
; 5: 
; 6: 
; 7: 'Uses 12f629 running at 3.3V
; 8: 
; 9: Symbol adf435x_LE = GP2
; 10: Symbol ADF435x_DATA = GP1
; 11: Symbol ADF435x_CLK = GP0
; 12: Symbol SW1 = GP4
; 13: Symbol SW2 = GP5
; 14: 'GP3 used as MCLR
; 15: 
; 16: TRISIO = %00111000  'GP0 , GP1, GP2 2 out, rest set to input.
	MOVLW 0x38
	BSF STATUS,RP0
	MOVWF TRISIO
	BCF STATUS,RP0
; 17: CMCON = %00000111  'Comparator off
	MOVLW 0x07
	MOVWF CMCON
; 18: WPU = %00111000  'weak pull ups off for outputs, on for inputs
	MOVLW 0x38
	BSF STATUS,RP0
	MOVWF WPU
; 19: OPTION.7 = 0  'Pull Ups on
	BCF OPTION_REG,7
	BCF STATUS,RP0
; 20: 
; 21: Disable  'no interupts
	BCF INTCON,GIE
; 22: 
; 23: 'Uses ADF425x register values as determined by AD Config Tool
; 24: 'egs
; 25: '1000MHz, 10MHz ref, -1dBm out , Muxout Dig Lock Detect
; 26: '{0xC80000, 0x8008011, 0x18004E42, 0x4B3, 0xA5002C, 0x580005}
; 27: '2000MHz, 10MHz ref, -1dBm out , Muxout Dig Lock Detect
; 28: '{0xC80000, 0x8008011, 0x18004E42, 0x4B3, 0x95002C, 0x580005}
; 29: '3000MHz, 10MHz ref, -1dBm out , Muxout Dig Lock Detect
; 30: '{0x960000, 0x8008011, 0x18004E42, 0x4B3, 0x85002C, 0x580005}
; 31: '4000MHz, 10MHz ref, -1dBm out , Muxout Dig Lock Detect
; 32: '{0xC80000, 0x8008011, 0x18004E42, 0x4B3, 0x85002C, 0x580005}
; 33: '4000MHz, 10MHz ref, +2dBm out , Muxout Dig Lock Detect
; 34: '{0xC80000, 0x8008011, 0x18004E42, 0x4B3, 0x850034, 0x580005}
; 35: 
; 36: Dim ADFRegs(6) As Long
; 37: 
; 38: Main:
L0001:
; 39: Dim Sel As Byte
; 40: Sel = 0
	CLRF 0x02C
; 41: Sel.0 = SW1
	BCF 0x02C,0
	BTFSC GPIO,4
	BSF 0x02C,0
; 42: Sel.1 = SW2
	BCF 0x02C,1
	BTFSC GPIO,5
	BSF 0x02C,1
; 43: 
; 44: Select Case Sel
; 45: Case 0  'both jumpers
	MOVF 0x02C,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0005
; 46: 'change to 1 Ghz
; 47: ADFRegs(0) = 0xc80000  '1000MHz (10MHz) +2dBm
	CLRF 0x030
	CLRF 0x031
	MOVLW 0xC8
	MOVWF 0x032
	CLRF 0x033
; 48: ADFRegs(1) = 0x8008011
	MOVLW 0x11
	MOVWF 0x034
	MOVLW 0x80
	MOVWF 0x035
	CLRF 0x036
	MOVLW 0x08
	MOVWF 0x037
; 49: ADFRegs(2) = 0x18004e42
	MOVLW 0x42
	MOVWF 0x038
	MOVLW 0x4E
	MOVWF 0x039
	CLRF 0x03A
	MOVLW 0x18
	MOVWF 0x03B
; 50: ADFRegs(3) = 0x000004b3
	MOVLW 0xB3
	MOVWF 0x03C
	MOVLW 0x04
	MOVWF 0x03D
	CLRF 0x03E
	CLRF 0x03F
; 51: ADFRegs(4) = 0xa50034
	MOVLW 0x34
	MOVWF 0x040
	CLRF 0x041
	MOVLW 0xA5
	MOVWF 0x042
	CLRF 0x043
; 52: ADFRegs(5) = 0x00580005
	MOVLW 0x05
	MOVWF 0x044
	CLRF 0x045
	MOVLW 0x58
	MOVWF 0x046
	CLRF 0x047
; 53: 
; 54: Case 1  'SW2 Jumper
	GOTO L0006
L0005:
	MOVF 0x02C,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0007
; 55: 'change to 2 Ghz
; 56: ADFRegs(0) = 0xc80000  '2000MHz (10MHz) +2dBm
	CLRF 0x030
	CLRF 0x031
	MOVLW 0xC8
	MOVWF 0x032
	CLRF 0x033
; 57: ADFRegs(1) = 0x8008011
	MOVLW 0x11
	MOVWF 0x034
	MOVLW 0x80
	MOVWF 0x035
	CLRF 0x036
	MOVLW 0x08
	MOVWF 0x037
; 58: ADFRegs(2) = 0x18004e42
	MOVLW 0x42
	MOVWF 0x038
	MOVLW 0x4E
	MOVWF 0x039
	CLRF 0x03A
	MOVLW 0x18
	MOVWF 0x03B
; 59: ADFRegs(3) = 0x000004b3
	MOVLW 0xB3
	MOVWF 0x03C
	MOVLW 0x04
	MOVWF 0x03D
	CLRF 0x03E
	CLRF 0x03F
; 60: ADFRegs(4) = 0x950034
	MOVLW 0x34
	MOVWF 0x040
	CLRF 0x041
	MOVLW 0x95
	MOVWF 0x042
	CLRF 0x043
; 61: ADFRegs(5) = 0x00580005
	MOVLW 0x05
	MOVWF 0x044
	CLRF 0x045
	MOVLW 0x58
	MOVWF 0x046
	CLRF 0x047
; 62: 
; 63: Case 2  'SW1 Jumper
	GOTO L0008
L0007:
	MOVF 0x02C,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0009
; 64: 
; 65: 'change to 2200 Mhz
; 66: ADFRegs(0) = 0x6e0000  '2200MHz (10MHz) +2dBm
	CLRF 0x030
	CLRF 0x031
	MOVLW 0x6E
	MOVWF 0x032
	CLRF 0x033
; 67: ADFRegs(1) = 0x8008011
	MOVLW 0x11
	MOVWF 0x034
	MOVLW 0x80
	MOVWF 0x035
	CLRF 0x036
	MOVLW 0x08
	MOVWF 0x037
; 68: ADFRegs(2) = 0x18004e42
	MOVLW 0x42
	MOVWF 0x038
	MOVLW 0x4E
	MOVWF 0x039
	CLRF 0x03A
	MOVLW 0x18
	MOVWF 0x03B
; 69: ADFRegs(3) = 0x000004b3
	MOVLW 0xB3
	MOVWF 0x03C
	MOVLW 0x04
	MOVWF 0x03D
	CLRF 0x03E
	CLRF 0x03F
; 70: ADFRegs(4) = 0x850034
	MOVLW 0x34
	MOVWF 0x040
	CLRF 0x041
	MOVLW 0x85
	MOVWF 0x042
	CLRF 0x043
; 71: ADFRegs(5) = 0x00580005
	MOVLW 0x05
	MOVWF 0x044
	CLRF 0x045
	MOVLW 0x58
	MOVWF 0x046
	CLRF 0x047
; 72: 
; 73: Case Else  'ie 3 Neither jumper
	GOTO L0010
L0009:
; 74: 'change to 1600 Mhz
; 75: ADFRegs(0) = 0xa00000  '1600MHz (10MHz) +2dBm
	CLRF 0x030
	CLRF 0x031
	MOVLW 0xA0
	MOVWF 0x032
	CLRF 0x033
; 76: ADFRegs(1) = 0x8008011
	MOVLW 0x11
	MOVWF 0x034
	MOVLW 0x80
	MOVWF 0x035
	CLRF 0x036
	MOVLW 0x08
	MOVWF 0x037
; 77: ADFRegs(2) = 0x18004e42
	MOVLW 0x42
	MOVWF 0x038
	MOVLW 0x4E
	MOVWF 0x039
	CLRF 0x03A
	MOVLW 0x18
	MOVWF 0x03B
; 78: ADFRegs(3) = 0x000004b3
	MOVLW 0xB3
	MOVWF 0x03C
	MOVLW 0x04
	MOVWF 0x03D
	CLRF 0x03E
	CLRF 0x03F
; 79: ADFRegs(4) = 0x950034
	MOVLW 0x34
	MOVWF 0x040
	CLRF 0x041
	MOVLW 0x95
	MOVWF 0x042
	CLRF 0x043
; 80: ADFRegs(5) = 0x00580005
	MOVLW 0x05
	MOVWF 0x044
	CLRF 0x045
	MOVLW 0x58
	MOVWF 0x046
	CLRF 0x047
; 81: 
; 82: EndSelect
L0010:
L0008:
L0006:
; 83: 
; 84: 'program ADF435x starting with R5
; 85: Dim i As Byte
; 86: For i = 5 To 0 Step -1
	MOVLW 0x05
	MOVWF 0x02E
L0011:
	MOVLW 0x00
	SUBWF 0x02E,W
	BTFSS STATUS,C
	GOTO L0012
; 87: Call WR32(ADFRegs(i))
	BCF STATUS,IRP
	BCF STATUS,C
	RLF 0x02E,W
	MOVWF FSR
	ADDWF FSR,W
	ADDLW 0x30
	MOVWF FSR
	MOVF INDF,W
	MOVWF 0x048
	INCF FSR,F
	MOVF INDF,W
	MOVWF 0x049
	INCF FSR,F
	MOVF INDF,W
	MOVWF 0x04A
	INCF FSR,F
	MOVF INDF,W
	MOVWF 0x04B
	CALL L0002
; 88: Next i
	MOVLW 0x01
	SUBWF 0x02E,F
	BTFSC STATUS,C
	GOTO L0011
L0012:
; 89: ASM:        SLEEP
	SLEEP
; 90: End
L0013:	GOTO L0013
; 91: Proc WR32(RegVal As Long)
L0002:
; 92: 'Write Bytes starting with MSByte
; 93: Call WByte(RegVal.4B)
	MOVF 0x04B,W
	MOVWF 0x02D
	CALL L0003
; 94: Call WByte(RegVal.3B)
	MOVF 0x04A,W
	MOVWF 0x02D
	CALL L0003
; 95: Call WByte(RegVal.HB)
	MOVF 0x049,W
	MOVWF 0x02D
	CALL L0003
; 96: Call WByte(RegVal.LB)
	MOVF 0x048,W
	MOVWF 0x02D
	CALL L0003
; 97: 'latch data into register
; 98: adf435x_LE = 1
	BSF GPIO,2
; 99: adf435x_LE = 0
	BCF GPIO,2
; 100: End Proc
	RETURN
; 101: Proc WByte(ByteVal As Byte)
L0003:
; 102: 'iterate over the 8 bits MSBit first
; 103: Dim j As Byte
; 104: For j = 7 To 0 Step -1
	MOVLW 0x07
	MOVWF 0x02F
L0014:
	MOVLW 0x00
	SUBWF 0x02F,W
	BTFSS STATUS,C
	GOTO L0015
; 105: ADF435x_DATA = ByteVal.j
	MOVF 0x02D,W
	MOVWF R1L
	MOVF 0x02F,W
	MOVWF R0H
	CALL BI01
	BCF GPIO,1
	BTFSC R1L,0
	BSF GPIO,1
; 106: 'clock data into shift register
; 107: ADF435x_CLK = 1
	BSF GPIO,0
; 108: ADF435x_CLK = 0
	BCF GPIO,0
; 109: Next j
	MOVLW 0x01
	SUBWF 0x02F,F
	BTFSC STATUS,C
	GOTO L0014
L0015:
; 110: End Proc
	RETURN
; 111: 
; Library code
; End of user code
L0016:	GOTO L0016
;
;
; Bit Index Routine
BI01:	INCF R0H,F
	RLF R1L,F
BI02:	RRF R1L,F
	DECFSZ R0H,F
	GOTO BI02
	RETURN
BI10:	MOVLW 0x09
	MOVWF R1H
	INCF R0H,F
	RLF R0L,F
	GOTO BI11
BI12:	BCF STATUS,C
	BTFSC R0L,0
	BSF STATUS,C
BI11:	RRF R0L,F
	DECF R0H,F
	BTFSC STATUS,Z
	CALL BI13
	DECFSZ R1H,F
	GOTO BI12
	RETURN
BI13:	BCF R0L,0
	BTFSC R1L,0
	BSF R0L,0
	RETURN
;
;
;
;
; Configuration settings
	ORG 0x2007
	DW 0x31E4
; End of listing
	END
