Define CONFIG = 0x31e4

'Ultra Simple ADF435x programmer SigGen Mix Version
'VK3DIP February 2021 V1.0


'Uses 12f629 running at 3.3V

Symbol adf435x_LE = GP2
Symbol ADF435x_DATA = GP1
Symbol ADF435x_CLK = GP0
Symbol SW1 = GP4
Symbol SW2 = GP5
'GP3 used as MCLR

TRISIO = %00111000  'GP0 , GP1, GP2 2 out, rest set to input.
CMCON = %00000111  'Comparator off
WPU = %00111000  'weak pull ups off for outputs, on for inputs
OPTION.7 = 0  'Pull Ups on

Disable  'no interupts

'Uses ADF425x register values as determined by AD Config Tool
'egs
'1000MHz, 10MHz ref, -1dBm out , Muxout Dig Lock Detect
'{0xC80000, 0x8008011, 0x18004E42, 0x4B3, 0xA5002C, 0x580005}
'2000MHz, 10MHz ref, -1dBm out , Muxout Dig Lock Detect
'{0xC80000, 0x8008011, 0x18004E42, 0x4B3, 0x95002C, 0x580005}
'3000MHz, 10MHz ref, -1dBm out , Muxout Dig Lock Detect
'{0x960000, 0x8008011, 0x18004E42, 0x4B3, 0x85002C, 0x580005}
'4000MHz, 10MHz ref, -1dBm out , Muxout Dig Lock Detect
'{0xC80000, 0x8008011, 0x18004E42, 0x4B3, 0x85002C, 0x580005}
'4000MHz, 10MHz ref, +2dBm out , Muxout Dig Lock Detect
'{0xC80000, 0x8008011, 0x18004E42, 0x4B3, 0x850034, 0x580005}

Dim ADFRegs(6) As Long

Main:
Dim Sel As Byte
Sel = 0
Sel.0 = SW1
Sel.1 = SW2

Select Case Sel
	Case 0  'both jumpers
	'change to 1 Ghz
		ADFRegs(0) = 0xc80000  '1000MHz (10MHz) +2dBm
		ADFRegs(1) = 0x8008011
		ADFRegs(2) = 0x18004e42
		ADFRegs(3) = 0x000004b3
		ADFRegs(4) = 0xa50034
		ADFRegs(5) = 0x00580005

	Case 1  'SW2 Jumper
	'change to 2 Ghz
		ADFRegs(0) = 0xc80000  '2000MHz (10MHz) +2dBm
		ADFRegs(1) = 0x8008011
		ADFRegs(2) = 0x18004e42
		ADFRegs(3) = 0x000004b3
		ADFRegs(4) = 0x950034
		ADFRegs(5) = 0x00580005

	Case 2  'SW1 Jumper

	'change to 2200 Mhz
		ADFRegs(0) = 0x6e0000  '2200MHz (10MHz) +2dBm
		ADFRegs(1) = 0x8008011
		ADFRegs(2) = 0x18004e42
		ADFRegs(3) = 0x000004b3
		ADFRegs(4) = 0x850034
		ADFRegs(5) = 0x00580005
		
	Case Else  'ie 3 Neither jumper
	'change to 1600 Mhz
		ADFRegs(0) = 0xa00000  '1600MHz (10MHz) +2dBm
		ADFRegs(1) = 0x8008011
		ADFRegs(2) = 0x18004e42
		ADFRegs(3) = 0x000004b3
		ADFRegs(4) = 0x950034
		ADFRegs(5) = 0x00580005
		
EndSelect

'program ADF435x starting with R5
Dim i As Byte
For i = 5 To 0 Step -1
	Call WR32(ADFRegs(i))
Next i
ASM:        SLEEP
End                                               
Proc WR32(RegVal As Long)
	'Write Bytes starting with MSByte
	Call WByte(RegVal.4B)
	Call WByte(RegVal.3B)
	Call WByte(RegVal.HB)
	Call WByte(RegVal.LB)
	'latch data into register
adf435x_LE = 1
	adf435x_LE = 0
End Proc                                          
Proc WByte(ByteVal As Byte)
'iterate over the 8 bits MSBit first
	Dim j As Byte
	For j = 7 To 0 Step -1
		ADF435x_DATA = ByteVal.j
		'clock data into shift register
		ADF435x_CLK = 1
		ADF435x_CLK = 0
	Next j
End Proc                                          

