/*
 GPSDO setup TP5 and communicate
 VK3DIP V1.0 25/08/2020
  Initial Version Set TP and Cut Through
 VK3DIP V1.1 20/10/2020
  Add set Nav Mode to Stationary to optimise TP stability.
 VK3DIP V2.0 25/03/2021 
  Add LCD and status etc.
 VK3DIP V2.1 30/03/2021 
  Add SI5351 and clean up code to reduce RAM usage
 VK3DIP V2.2 01/04/2021 
 rearange code some more to reduce RAM usage   
  
  */
 
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2);  // set the LCD address to 0x27 for a 16 chars and 2 line display

#include <SoftwareSerial.h>
SoftwareSerial GPS(4, 3);

#include <TinyGPS++.h>
// The TinyGPS++ object
TinyGPSPlus gps;

// add SI5351
#include "si5351.h"
#include "Wire.h"
Si5351 si5351;


// Setup everything *************************************************************************************    
void setup()
{
  // Start USB/Serial back to PC @ 9600
  Serial.begin(9600);
  Serial.println(" ");
  Serial.println(F("Neo-7+ GPSDO "));
  Serial.println(F("VK3DIP V2.2 April 2021"));
  
  // Do LCD Setup
  lcd.init();
  lcd.clear();         
  lcd.backlight();      // Make sure backlight is on

    // Print startup message to the LCD.
  lcd.setCursor(0,0);   //Set cursor to character 0 on line 0
  lcd.print(F("VK3DIP GPSDO V2+")); 
  lcd.setCursor(0,1);   //Move cursor to character 0 on line 1
  lcd.print(F("Start Setup....."));

  // Do GPS Setup  
  // Start GPS Serial at default 9600
   GPS.begin(9600); 
   GPSSetup();

    
  // initialize the Si5351 and set frequencies
   lcd.setCursor(0,1);   //Move cursor to character 0 on line 1
   lcd.print(F("Setup SI5351....")); //Using all 16chars so no clear needed
   Serial.println(F("Setup SI5351...."));
   MySetSI5351();
    
  
  // Setup done,
  Serial.println(F("Setup done ..."));
  Serial.println(" ");
  lcd.setCursor(0,1);   //Move cursor to character 0 on line 1
  lcd.print(F("Set up complete ")); //Using all 16chars so no clear needed
  
} // end Setup ********************************************************************************************


 // Main loop just to service the GPS **********************************************************************
void loop()
{
  lcd.clear(); 
  while(1)
  {
    if(GPS.available())
    {
      // Read GPS Serial inputs (if available) and send them to encoder
      gps.encode(GPS.read());

      // check if we have enough to do anything.
      GotAny();
 
     } // end gps available  
    } // end While
  } // end Loop  ********************************************************************************************


 
// ********************************Subs and Functions *******************************************************

// GPS Setup ************************************************************************************************
void GPSSetup(){
  // 
  // 
  uint8_t UBXNav[] = {
    0xB5, 0x62, 0x06, 0x24, 0x24, 0x00, 0xFF, 0xFF, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x10, 0x27,
    0x00, 0x00, 0x05, 0x00, 0xFA, 0x00, 0xFA, 0x00, 0x64, 0x00, 0x2C, 0x01, 0x00, 0x3C, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x60 }; 
  
   //  This UBX command sets the Navigation Mode to Stationary which is optimal for accuracy of Time Pulse
  Serial.println(F("Setting uBlox Nav mode: "));
  lcd.setCursor(0,1);   //Move cursor to character 0 on line 1
  lcd.print(F("Set up Nav mode.")); //Using all 16chars so no clear needed
  RepSendUBXBuf(UBXNav,sizeof(UBXNav)/sizeof(uint8_t));

 //  This UBX command sets the TimePulse to 1HZ unlocked, 100KHz Locked, both 50% duty cycle
  Serial.println(F("Initialize TP5 to 100KHz ..."));  
  lcd.setCursor(0,1);   //Move cursor to character 0 on line 1
  lcd.print(F("Init TP = 100KHz")); //Using all 16chars so no clear needed
   uint8_t UBXTP[] = {
    0xB5, 0x62, 0x06, 0x31, 0x20, 0x00, 0x00, 0x01, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x00, 0xA0, 0x86, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
    0x00, 0x00, 0xEF, 0x00, 0x00, 0x00, 0xA1, 0xBA };
   RepSendUBXBuf(UBXTP,sizeof(UBXTP)/sizeof(uint8_t));

 // get rid of all normal messages except GGA
  Serial.println(F("Turn off all messages save GGA "));
  lcd.setCursor(0,1);   //Move cursor to character 0 on line 1
  lcd.print(F("Enable GGA only ")); //Using all 16chars so no clear needed
  
   Serial.println(F("Switching off NMEA GLL: "));
  uint8_t UBXGLL[] = {
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x2B };
   RepSendUBXBuf(UBXGLL,sizeof(UBXGLL)/sizeof(uint8_t));

   Serial.println(F("Switching off NMEA GSA: "));
    uint8_t UBXGSA[] = {
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x32 };
  RepSendUBXBuf(UBXGSA,sizeof(UBXGSA)/sizeof(uint8_t));

   Serial.println(F("Switching off NMEA GSV: "));
    uint8_t UBXGSV[] = {
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x39 };
   RepSendUBXBuf(UBXGSV,sizeof(UBXGSV)/sizeof(uint8_t));

   Serial.print(F("Switching off NMEA RMC: "));
   uint8_t UBXRMC[] = { 
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x40 };
   RepSendUBXBuf(UBXRMC,sizeof(UBXRMC)/sizeof(uint8_t));

   Serial.print(F("Switching off NMEA VTG: "));
   uint8_t UBXVTG[] = { 
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x47                   };
   RepSendUBXBuf(UBXVTG,sizeof(UBXVTG)/sizeof(uint8_t));
  
  lcd.setCursor(0,1);   //Move cursor to character 0 on line 1
  lcd.print(F("Now GGA only    ")); //Using all 16chars so no clear needed  
} // end GPSSetup ******************************************************************************************************


// keep sending UBX message until we get +ve ack ***********************************************************************
// allows for possible serial problems
void RepSendUBXBuf(uint8_t *MSG, uint8_t len){
   byte gps_set_sucess=0;
   while(!gps_set_sucess)
  {
    for(int i=0; i<len; i++) {
      GPS.write(MSG[i]);
      if ( i % 10 == 0 && i != 0) Serial.println() ;
      PrnHEX(MSG[i]);
    }
  GPS.println();
  gps_set_sucess=getUBX_ACK(MSG);
  }
 } //end RepSendUBXBuf  ************************************************************************************************

// Calculate expected UBX ACK packet and parse UBX response from GPS ***************************************************
boolean getUBX_ACK(uint8_t *MSG) {
  uint8_t b;
  uint8_t ackByteID = 0;
  uint8_t ackPacket[10];
  unsigned long startTime = millis();
  Serial.println();
  Serial.print("Reading ACK response: ");
 Serial.println();
  // Construct the expected ACK packet    
  ackPacket[0] = 0xB5;  // header
  ackPacket[1] = 0x62;  // header
  ackPacket[2] = 0x05;  // class
  ackPacket[3] = 0x01;  // id
  ackPacket[4] = 0x02;  // length
  ackPacket[5] = 0x00;
  ackPacket[6] = MSG[2];  // ACK class
  ackPacket[7] = MSG[3];  // ACK id
  ackPacket[8] = 0;   // CK_A
  ackPacket[9] = 0;   // CK_B
 
  // Calculate the checksums
  for (uint8_t i=2; i<8; i++) {
    ackPacket[8] = ackPacket[8] + ackPacket[i];
    ackPacket[9] = ackPacket[9] + ackPacket[8];
  }
 
  while (1) {
 
    // Test for success
    if (ackByteID > 9) {
      // All packets in order!
      Serial.println(" (SUCCESS!)");
      return true;
    }
 
    // Timeout if no valid response in 3 seconds
    if (millis() - startTime > 3000) { 
      Serial.println(" (FAILED!) Try Again");
      return false;
    }
 
    // Make sure data is available to read
    if (GPS.available()) {
      b = GPS.read();
 
      // Check that bytes arrive in sequence as per expected ACK packet
      if (b == ackPacket[ackByteID]) { 
        ackByteID++;
        PrnHEX(b);
      } 
      else {
        ackByteID = 0;  // Reset and look again, invalid order
      }
 
    }
  }
} // end getUBX_ACK ***************************************************************************************************

// Print Hex Chars nicely. ********************************************************************************************
 void PrnHEX(uint8_t MyChr) {
 
    Serial.print("0x");
    Serial.print(MyChr < 16 ? "0" : "");
    Serial.print(MyChr, HEX);
    Serial.print(" ");
    
} //end PrnHEX ********************************************************************************************************

// Check for any decoded data and action if present *******************************************************************
void GotAny() {
   if (gps.location.isUpdated()) // if enough for a location
       {   
         lcd.setCursor(0,1);   //Set cursor to character 0 on line 1
         char myloc[9]; //array to hold locator string
         calcLocator(myloc, gps.location.lat(), gps.location.lng());
         lcd.print(myloc);
       }

    if (gps.altitude.isUpdated()) // got altitude
       {
         lcd.setCursor(9,1);   //Set cursor to character 9 on line 1
         lcd.print(gps.altitude.meters());
         lcd.print(F("m")); 
       }

    if (gps.satellites.isUpdated()) // got satellites
       {
        lcd.setCursor(9,0);   //Set cursor to character 9 on line 0
        lcd.print(F("  "));  // clean out to allow for less than 10 satelites
        lcd.setCursor(9,0);   //Set cursor to character 9 on line 0
        lcd.print(gps.satellites.value());
       }

    if (gps.hdop.isUpdated()) // got HDOP
       {
        lcd.setCursor(12,0);   //Set cursor to character 12 on line 0
        lcd.print(gps.hdop.hdop());
       }

      if (gps.time.isUpdated()) // got Time
       {
        lcd.setCursor(0,0);   //Set cursor to character 0 on line 0
        MyUTC(); // LCD print time
       } 
}// end GotAny ********************************************************************************************************



// Send Good Time to LCD at current cursor ****************************************************************************

void MyUTC() {
   if (gps.time.isValid())
  {
    if (gps.time.hour() < 10) lcd.print(F("0"));
    lcd.print(gps.time.hour());
    lcd.print(F(":"));
    if (gps.time.minute() < 10) lcd.print(F("0"));
    lcd.print(gps.time.minute());
    lcd.print(F(":"));
    if (gps.time.second() < 10) lcd.print(F("0"));
    lcd.print(gps.time.second());
    //lcd.print(F("."));
    //if (gps.time.centisecond() < 10) lcd.print(F("0"));
    //lcd.print(gps.time.centisecond());
  }
  else
  {
    lcd.print(F("INVALID "));
  }
}  // end MyUTC  ******************************************************************************************************

// calculate maidenhead gridsquare from given latitude and longitude **************************************************
// returns 8 char grid locator in elsewhere declared 9 char array loc passed by *pointer

void calcLocator(char *loc, double latitude, double longitude) {
  // Latitude and longitude are in decimal degrees
  // *loc is a reference to a char array declared global elsewhere
  int tempint; // int variable to hold individual chars
  double remainder; // keep track of remainder
 
  // do longitude calcs
  remainder = longitude + 180.0;
  tempint = (int)(remainder / 20.0);
  remainder = remainder - (double)tempint * 20.0;
  loc[0] = (char)tempint + 'A';
   
  tempint = (int)(remainder / 2.0);
  remainder = remainder - 2.0 * (double)tempint;
  loc[2] = (char)tempint + '0';
   
  tempint = (int)(12.0 * remainder);
  remainder = remainder - (double)tempint / 12;
  loc[4] = (char)tempint + 'a';
  
  tempint = (int)(remainder *120);
  loc[6] = (char)tempint + '0';
  
  // do latitude calcs
  remainder = latitude + 90.0;
  tempint = (int)(remainder / 10.0);
  remainder = remainder - (double)tempint * 10.0;
  loc[1] = (char)tempint + 'A';
  
  tempint = (int)(remainder);
  remainder = remainder - (double)tempint;
  loc[3] = (char)tempint + '0';
  
  tempint = (int)(24.0 * remainder);
  remainder = remainder - (double)tempint / 24;
  loc[5] = (char)tempint + 'a';
  
  tempint = (int)(remainder * 240);
  loc[7] = (char)tempint + '0';
  
  //terminate result
   loc[8] = (char)0;
} // end calcLocator *********************************************************************************************************


// Set frequencies for the SI5351 ********************************************************************************************
// Assume called only after 10MHz ref is available.
void MySetSI5351() {
    bool i2c_found;


     i2c_found = si5351.init(SI5351_CRYSTAL_LOAD_0PF, 10000000UL, 0); // set for 10MHz input
     if(!i2c_found)
       {
          Serial.println(F("Device not found on I2C bus!"));
       }

     // Assume if we are here that 10MHz ref is available
  
  // Set CLK0 to output 22.625 MHz for Yaesu FT8x7
  si5351.set_freq(2262500000ULL, SI5351_CLK0);

  // Set CLK1 to output 15.6 MHz
  si5351.set_freq(1560000000ULL, SI5351_CLK1);

    // Set CLK2 to output 30.2 MHz
  si5351.set_freq(3020000000ULL, SI5351_CLK2);

 delay(500); // delay a bit to stabalize
 
} //end MySetSI5351  **********************************************************************************************************
 
