/*
 GPSDO setup TP5 and communicate
 VK3DIP V1.0 25/08/2020
  Initial Version Set TP and Cut Through
 VK3DIP V1.1 20/10/2020
  Add set Nav Mode to Stationary to optimise TP stability.
  
 Based on code found at https://ukhas.org.uk/guides:ublox6
 Additional Code by J Coxon (http://ukhas.org.uk/guides:falcom_fsa03)
 */
 
#include <SoftwareSerial.h>
SoftwareSerial GPS(4, 3);
byte gps_set_sucess = 0 ;
 
void setup()
{
  // Start GPS Serial at default 9600
  GPS.begin(9600); 
  // Start USB/Serial back to PC also 9600
  Serial.begin(9600);

  Serial.println(" ");
  Serial.println("Neo-7+ GPSDO ");
  Serial.println("VK3DIP V1.1 Oct. 2020");
  Serial.println("Initialize TP to 100KHz ...");
  
  //  This UBX command sets the TimePulse to 1HZ unlocked, 100KHz Locked, both 50% duty cycle
  Serial.println("Setting uBlox TP5 mode: ");
  uint8_t setTP5[] = {
    0xB5, 0x62, 0x06, 0x31, 0x20, 0x00, 0x00, 0x01, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x00, 0xA0, 0x86, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
    0x00, 0x00, 0xEF, 0x00, 0x00, 0x00, 0xA1, 0xBA };
  while(!gps_set_sucess)
  {
    sendUBX(setTP5, sizeof(setTP5)/sizeof(uint8_t));
    gps_set_sucess=getUBX_ACK(setTP5);
  }
  gps_set_sucess=0;
 Serial.println("TP Set successfully ");
  
  //  This UBX command sets the Navigation Mode to Stationary which is optimal for accuracy of Time Pulse
  Serial.println("Setting uBlox Nav mode: ");
  uint8_t setNav[] = {
    0xB5, 0x62, 0x06, 0x24, 0x24, 0x00, 0xFF, 0xFF, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x10, 0x27,
    0x00, 0x00, 0x05, 0x00, 0xFA, 0x00, 0xFA, 0x00, 0x64, 0x00, 0x2C, 0x01, 0x00, 0x3C, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x60 };
  while(!gps_set_sucess)
  {
    sendUBX(setNav, sizeof(setNav)/sizeof(uint8_t));
    gps_set_sucess=getUBX_ACK(setNav);
  }
  gps_set_sucess=0;
  
// get rid of all normal measages except GGA

 
  Serial.println("Switching off NMEA GLL: ");
   uint8_t setGLL[] = { 
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x2B                   };
   while(!gps_set_sucess)
   {    
   sendUBX(setGLL, sizeof(setGLL)/sizeof(uint8_t));
   gps_set_sucess=getUBX_ACK(setGLL);
   }
   gps_set_sucess=0;
 
   Serial.println("Switching off NMEA GSA: ");
   uint8_t setGSA[] = { 
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x32                   };
   while(!gps_set_sucess)
   {  
   sendUBX(setGSA, sizeof(setGSA)/sizeof(uint8_t));
   gps_set_sucess=getUBX_ACK(setGSA);
   }
   gps_set_sucess=0;
   Serial.println("Switching off NMEA GSV: ");
   uint8_t setGSV[] = { 
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x39                   };
   while(!gps_set_sucess)
   {
   sendUBX(setGSV, sizeof(setGSV)/sizeof(uint8_t));
   gps_set_sucess=getUBX_ACK(setGSV);
   }
   gps_set_sucess=0;
   Serial.print("Switching off NMEA RMC: ");
   uint8_t setRMC[] = { 
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x40                   };
   while(!gps_set_sucess)
   {
   sendUBX(setRMC, sizeof(setRMC)/sizeof(uint8_t));
   gps_set_sucess=getUBX_ACK(setRMC);
   }
      gps_set_sucess=0;
   Serial.print("Switching off NMEA VTG: ");
   uint8_t setVTG[] = { 
   0xB5, 0x62, 0x06, 0x01, 0x08, 0x00, 0xF0, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x47                   };
   while(!gps_set_sucess)
   {
   sendUBX(setVTG, sizeof(setVTG)/sizeof(uint8_t));
   gps_set_sucess=getUBX_ACK(setVTG);
   }
    gps_set_sucess=0;
    
 Serial.println("Done now cutthrough ...");
 Serial.println(" ");
}
 
void loop()
{
  while(1)
  {
    if(GPS.available())
    {
      // Read GPS Serial inputs (if available) and send them to the USB/Serial/PC
      Serial.write(GPS.read()); 
    }
  //Read USB/Serial/PC inputs (if available) and send them to GPS module
  if(Serial.available()){    
    GPS.write(Serial.read());
  }
  }
}  
 
// Subs and functions 
 
// Send a byte array of UBX protocol to the GPS
void sendUBX(uint8_t *MSG, uint8_t len) {
 // Serial.println("Send UBX Command:");
  for(int i=0; i<len; i++) {
    GPS.write(MSG[i]);
    if ( i % 10 == 0 && i != 0) Serial.println() ;
    PrnHEX(MSG[i]);
  }
  GPS.println();
}

// Print Hex Chars nicely.
 void PrnHEX(uint8_t MyChr) {
 
    Serial.print("0x");
    Serial.print(MyChr < 16 ? "0" : "");
    Serial.print(MyChr, HEX);
    Serial.print(" ");
    
}
 
// Calculate expected UBX ACK packet and parse UBX response from GPS
boolean getUBX_ACK(uint8_t *MSG) {
  uint8_t b;
  uint8_t ackByteID = 0;
  uint8_t ackPacket[10];
  unsigned long startTime = millis();
  Serial.println();
  Serial.print("Reading ACK response: ");
 Serial.println();
  // Construct the expected ACK packet    
  ackPacket[0] = 0xB5;  // header
  ackPacket[1] = 0x62;  // header
  ackPacket[2] = 0x05;  // class
  ackPacket[3] = 0x01;  // id
  ackPacket[4] = 0x02;  // length
  ackPacket[5] = 0x00;
  ackPacket[6] = MSG[2];  // ACK class
  ackPacket[7] = MSG[3];  // ACK id
  ackPacket[8] = 0;   // CK_A
  ackPacket[9] = 0;   // CK_B
 
  // Calculate the checksums
  for (uint8_t i=2; i<8; i++) {
    ackPacket[8] = ackPacket[8] + ackPacket[i];
    ackPacket[9] = ackPacket[9] + ackPacket[8];
  }
 
  while (1) {
 
    // Test for success
    if (ackByteID > 9) {
      // All packets in order!
      Serial.println(" (SUCCESS!)");
      return true;
    }
 
    // Timeout if no valid response in 3 seconds
    if (millis() - startTime > 3000) { 
      Serial.println(" (FAILED!) Try Again");
      return false;
    }
 
    // Make sure data is available to read
    if (GPS.available()) {
      b = GPS.read();
 
      // Check that bytes arrive in sequence as per expected ACK packet
      if (b == ackPacket[ackByteID]) { 
        ackByteID++;
        PrnHEX(b);
      } 
      else {
        ackByteID = 0;  // Reset and look again, invalid order
      }
 
    }
  }
}
